<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="iva">
		<iva>
			<TipoIDInformante>R</TipoIDInformante>
			<xsl:copy-of select="IdInformante" />

			<razonSocial>
				<xsl:value-of select="razonSocial" />
			</razonSocial>
			<Anio>
				<xsl:value-of select="Anio" />
			</Anio>
			<Mes>
				<xsl:value-of select="Mes" />
			</Mes>
			
			<xsl:variable name="anio" select="Anio" />
			<xsl:variable name="mes" select="Mes" />
			
			<xsl:if test="regimenMicroempresa!=''">
				<xsl:copy-of select="regimenMicroempresa" />
			</xsl:if>
						
			<!-- Campos de numero de establecimientos y total de ventas -->
			<numEstabRuc>
				<xsl:value-of select="numEstabRuc" />
			</numEstabRuc>
			<totalVentas>
				<xsl:call-template name="default-number">
					<xsl:with-param name="valorNumerico" select="totalVentas" />
				</xsl:call-template>
			</totalVentas>
			<codigoOperativo>IVA</codigoOperativo>
			<!-- COMPRAS -->
			<xsl:if test="compras">
				<compras>
					<xsl:for-each select="compras/cabecerasCompras/cabeceraCompra">
						<xsl:if test=" codCompra != '' ">
							<detalleCompras>
								<xsl:variable name="codigoCompra" select="codCompra" />
								<xsl:copy-of select="codSustento" />
								<xsl:copy-of select="tpIdProv" />
								<xsl:copy-of select="idProv" />
								<xsl:copy-of select="tipoComprobante" />

								<xsl:if test="tipoProv!=''">
									<xsl:copy-of select="tipoProv" />
								</xsl:if>
								<xsl:if test="denoProv!=''">
									<xsl:copy-of select="denoProv" />
								</xsl:if>

								<xsl:copy-of select="parteRel" />
								<fechaRegistro>
									<xsl:call-template name="date-converter">
										<xsl:with-param name="fecha" select="fechaRegistro" />
									</xsl:call-template>
								</fechaRegistro>
								<xsl:copy-of select="establecimiento" />
								<xsl:copy-of select="puntoEmision" />
								<xsl:copy-of select="secuencial" />
								<fechaEmision>
									<xsl:call-template name="date-converter">
										<xsl:with-param name="fecha" select="fechaEmision" />
									</xsl:call-template>
								</fechaEmision>

								<xsl:copy-of select="autorizacion" />

								<baseNoGraIva>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="baseNoGraIva" />
									</xsl:call-template>
								</baseNoGraIva>
								<baseImponible>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="baseImponible" />
									</xsl:call-template>
								</baseImponible>
								<baseImpGrav>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="baseImpGrav" />
									</xsl:call-template>
								</baseImpGrav>
								<baseImpExe>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="baseImpExe" />
									</xsl:call-template>
								</baseImpExe>
								<montoIce>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="montoIce" />
									</xsl:call-template>
								</montoIce>
								<montoIva>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="montoIva" />
									</xsl:call-template>
								</montoIva>
								<valRetBien10>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="valRetBien10" />
									</xsl:call-template>
								</valRetBien10>
								<valRetServ20>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="valRetServ20" />
									</xsl:call-template>
								</valRetServ20>
								<valorRetBienes>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="valorRetBienes" />
									</xsl:call-template>
								</valorRetBienes>								
								<xsl:choose>
									<xsl:when test="$anio &gt;='2016'">
										<valRetServ50>
											<xsl:call-template name="default-number">
												<xsl:with-param name="valorNumerico" select="valRetServ50" />
											</xsl:call-template>
										</valRetServ50>
									</xsl:when>
								</xsl:choose>
								<valorRetServicios>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="valorRetServicios" />
									</xsl:call-template>
								</valorRetServicios>
								<valRetServ100>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="valRetServ100" />
									</xsl:call-template>
								</valRetServ100>
								<valorRetencionNc>
                                    <xsl:call-template name="default-number">
                                        <xsl:with-param name="valorNumerico" select="valorRetencionNc" />
                                    </xsl:call-template>
                                </valorRetencionNc>
								<totbasesImpReemb>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="totBasesImpReemb" />
									</xsl:call-template>
								</totbasesImpReemb>

								<xsl:if test="pagoExterior/pagoLocExt!=''">
									<pagoExterior>
										<xsl:call-template name="pagoLocalYDelExterior">
											<xsl:with-param name="pagoExterior" select="pagoExterior" />
										</xsl:call-template>
									</pagoExterior>
								</xsl:if>
								<xsl:if test="../../formasDePago/formaPago[codModulo=$codigoCompra]">
									<formasDePago>
										<xsl:for-each
											select="../../formasDePago/formaPago[codModulo=$codigoCompra]">
											<formaPago>
												<xsl:value-of select="forma" />
											</formaPago>
										</xsl:for-each>
									</formasDePago>
								</xsl:if>
								<xsl:if test="../../retencionesCompras">
									<air>
										<xsl:for-each
											select="../../retencionesCompras/detalleAir[codCompra=$codigoCompra]">
											<detalleAir>
												<xsl:copy-of select="codRetAir" />
												<baseImpAir>
													<xsl:call-template name="default-number">
														<xsl:with-param name="valorNumerico"
															select="baseImpAir" />
													</xsl:call-template>
												</baseImpAir>
												<porcentajeAir>
													<xsl:call-template name="default-number">
														<xsl:with-param name="valorNumerico"
															select="porcentajeAir" />
													</xsl:call-template>
												</porcentajeAir>
												<valRetAir>
													<xsl:call-template name="default-number">
														<xsl:with-param name="valorNumerico"
															select="valRetAir" />
													</xsl:call-template>
												</valRetAir>
												<xsl:if test="fechaPagoDiv!=''">
													<fechaPagoDiv>
														<xsl:call-template name="date-converter">
															<xsl:with-param name="fecha" select="fechaPagoDiv" />
														</xsl:call-template>
													</fechaPagoDiv>
													<imRentaSoc>
														<xsl:call-template name="default-number">
															<xsl:with-param name="valorNumerico"
																select="imRentaSoc" />
														</xsl:call-template>
													</imRentaSoc>
													<anioUtDiv>
														<xsl:value-of select="anioUtDiv" />
													</anioUtDiv>
												</xsl:if>
												<xsl:if test="numCajBan">
													<numCajBan>
														<xsl:call-template name="default-number">
															<xsl:with-param name="valorNumerico"
																select="numCajBan" />
														</xsl:call-template>
													</numCajBan>
												</xsl:if>
												<xsl:if test="precCajBan">
													<precCajBan>
														<xsl:call-template name="default-number">
															<xsl:with-param name="valorNumerico"
																select="precCajBan" />
														</xsl:call-template>
													</precCajBan>
												</xsl:if>
											</detalleAir>
										</xsl:for-each>
									</air>
								</xsl:if>
								<xsl:if test="estabRetencion1!=''">
									<estabRetencion1>
										<xsl:value-of select="estabRetencion1" />
									</estabRetencion1>
									<ptoEmiRetencion1>
										<xsl:value-of select="ptoEmiRetencion1" />
									</ptoEmiRetencion1>
									<secRetencion1>
										<xsl:value-of select="secRetencion1" />
									</secRetencion1>
									<autRetencion1>
										<xsl:value-of select="autRetencion1" />
									</autRetencion1>
									<fechaEmiRet1>
										<xsl:call-template name="date-converter">
											<xsl:with-param name="fecha" select="fechaEmiRet1" />
										</xsl:call-template>
									</fechaEmiRet1>
								</xsl:if>
								<xsl:if test="docModificado!=''">
									<docModificado>
										<xsl:value-of select="docModificado" />
									</docModificado>
									<estabModificado>
										<xsl:value-of select="estabModificado" />
									</estabModificado>
									<ptoEmiModificado>
										<xsl:value-of select="ptoEmiModificado" />
									</ptoEmiModificado>
									<secModificado>
										<xsl:value-of select="secModificado" />
									</secModificado>
									<autModificado>
										<xsl:value-of select="autModificado" />
									</autModificado>
								</xsl:if>
								<xsl:if test="../../reembolsos/reembolso[codCompra=$codigoCompra]">
									<reembolsos>
										<xsl:for-each
											select="../../reembolsos/reembolso[codCompra=$codigoCompra]">

											<reembolso>
												<tipoComprobanteReemb>
													<xsl:value-of select="tipoComprobanteReemb" />
												</tipoComprobanteReemb>
												<tpIdProvReemb>
													<xsl:value-of select="tpIdProvReemb" />
												</tpIdProvReemb>
												<idProvReemb>
													<xsl:value-of select="idProvReemb" />
												</idProvReemb>
												<establecimientoReemb>
													<xsl:value-of select="establecimientoReemb" />
												</establecimientoReemb>
												<puntoEmisionReemb>
													<xsl:value-of select="puntoEmisionReemb" />
												</puntoEmisionReemb>
												<secuencialReemb>
													<xsl:value-of select="secuencialReemb" />
												</secuencialReemb>
												<fechaEmisionReemb>
													<xsl:call-template name="date-converter">
														<xsl:with-param name="fecha" select="fechaEmisionReemb" />
													</xsl:call-template>
												</fechaEmisionReemb>
												<autorizacionReemb>
													<xsl:value-of select="autorizacionReemb" />
												</autorizacionReemb>
												<baseImponibleReemb>
													<xsl:call-template name="default-number">
														<xsl:with-param name="valorNumerico"
															select="baseImponibleReemb" />
													</xsl:call-template>
												</baseImponibleReemb>
												<baseImpGravReemb>
													<xsl:call-template name="default-number">
														<xsl:with-param name="valorNumerico"
															select="baseImpGravReemb" />
													</xsl:call-template>
												</baseImpGravReemb>
												<baseNoGraIvaReemb>
													<xsl:call-template name="default-number">
														<xsl:with-param name="valorNumerico"
															select="baseNoGraIvaReemb" />
													</xsl:call-template>
												</baseNoGraIvaReemb>
												<baseImpExeReemb>
													<xsl:call-template name="default-number">
														<xsl:with-param name="valorNumerico"
															select="baseImpExeReemb" />
													</xsl:call-template>
												</baseImpExeReemb>
												<montoIceRemb>
													<xsl:call-template name="default-number">
														<xsl:with-param name="valorNumerico"
															select="montoIceRemb" />
													</xsl:call-template>
												</montoIceRemb>
												<montoIvaRemb>
													<xsl:call-template name="default-number">
														<xsl:with-param name="valorNumerico"
															select="montoIvaRemb" />
													</xsl:call-template>
												</montoIvaRemb>
											</reembolso>
										</xsl:for-each>
									</reembolsos>
								</xsl:if>
							</detalleCompras>
						</xsl:if>
					</xsl:for-each>
				</compras>
			</xsl:if>
			<xsl:if test="ventas">
				<ventas>
					<xsl:for-each select="ventas/detalleVentas">
						<xsl:if test=" codVenta != '' ">
							<detalleVentas>
								<xsl:variable name="codigoVenta" select="codVenta" />

								<xsl:copy-of select="tpIdCliente" />
								<xsl:copy-of select="idCliente" />
								<xsl:if test="parteRelVtas != '' ">
									<xsl:copy-of select="parteRelVtas" />
								</xsl:if>
								<xsl:if test="tipoCliente!=''">
									<xsl:copy-of select="tipoCliente" />
								</xsl:if>
								<xsl:if test="denoCli!=''">
									<xsl:copy-of select="denoCli" />
								</xsl:if>
								<xsl:copy-of select="tipoComprobante" />
								<xsl:copy-of select="tipoEmision" />
								<xsl:copy-of select="numeroComprobantes" />

								<baseNoGraIva>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="baseNoGraIva" />
									</xsl:call-template>
								</baseNoGraIva>
								<baseImponible>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="baseImponible" />
									</xsl:call-template>
								</baseImponible>
								<baseImpGrav>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="baseImpGrav" />
									</xsl:call-template>
								</baseImpGrav>
								<montoIva>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="montoIva" />
									</xsl:call-template>
								</montoIva>
								<xsl:if test="../compensaciones">
									<xsl:if
										test="../compensaciones/compensacion[codModulo=$codigoVenta]">
										<compensaciones>
											<xsl:for-each
												select="../compensaciones/compensacion[codModulo=$codigoVenta]">
												<compensacion>
													<xsl:copy-of select="tipoCompe" />
													<monto>
														<xsl:call-template name="default-number">
															<xsl:with-param name="valorNumerico"
																select="monto" />
														</xsl:call-template>
													</monto>
												</compensacion>
											</xsl:for-each>
										</compensaciones>
									</xsl:if>
								</xsl:if>
								<montoIce>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="montoIce" />
									</xsl:call-template>
								</montoIce>

								<valorRetIva>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="valorRetIva" />
									</xsl:call-template>
								</valorRetIva>
								<valorRetRenta>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="valorRetRenta" />
									</xsl:call-template>
								</valorRetRenta>
								<xsl:if test="../formasDePago">
									<xsl:if test="../formasDePago/formaPago[codModulo=$codigoVenta]">
										<formasDePago>
											<xsl:for-each
												select="../formasDePago/formaPago[codModulo=$codigoVenta]">
												<formaPago>
													<xsl:value-of select="forma" />
												</formaPago>
											</xsl:for-each>
										</formasDePago>
									</xsl:if>
								</xsl:if>
							</detalleVentas>
						</xsl:if>
					</xsl:for-each>
				</ventas>
			</xsl:if>
			<!-- ventas por establecimiento -->
			<xsl:if test="ventasEstablecimiento">
				<ventasEstablecimiento>
					<xsl:for-each select="ventasEstablecimiento/ventaEst">
						<ventaEst>
							<codEstab>
								<xsl:value-of select="codEstab" />
							</codEstab>
							<ventasEstab>
								<xsl:call-template name="default-number">
									<xsl:with-param name="valorNumerico" select="ventasEstab" />
								</xsl:call-template>
							</ventasEstab>
							<ivaComp>
								<xsl:call-template name="default-number">
									<xsl:with-param name="valorNumerico" select="ivaComp" />
								</xsl:call-template>
							</ivaComp>
						</ventaEst>
					</xsl:for-each>
				</ventasEstablecimiento>
			</xsl:if>
			<!-- exportaciones -->
			<xsl:if test="exportaciones/detalleExportaciones">
				<exportaciones>
					<xsl:for-each select="exportaciones/detalleExportaciones">
						<detalleExportaciones>
							<xsl:copy-of select="tpIdClienteEx" />
							<xsl:copy-of select="idClienteEx" />
							<xsl:copy-of select="parteRelExp" />
							<xsl:if test="tipoCli != ''">
								<xsl:copy-of select="tipoCli" />
							</xsl:if>
							<xsl:if test="denoExpCli != ''">
								<xsl:copy-of select="denoExpCli" />
							</xsl:if>
							<xsl:if test="tipoRegi != ''">
								<xsl:copy-of select="tipoRegi" />
							</xsl:if>
							<xsl:if test="paisEfecPagoGen != ''">
								<xsl:copy-of select="paisEfecPagoGen" />
							</xsl:if>
							<xsl:if test="paisEfecPagoParFis != ''">
								<xsl:copy-of select="paisEfecPagoParFis" />
							</xsl:if>
							<xsl:if test="denopagoRegFis != ''">
								<xsl:copy-of select="denopagoRegFis" />
							</xsl:if>
							<xsl:if test="paisEfecExp != ''">
								<xsl:copy-of select="paisEfecExp" />
							</xsl:if>
							<exportacionDe>
								<xsl:value-of select="exportacionDe" />
							</exportacionDe>

							<xsl:if test="tipIngExt != ''">
								<xsl:copy-of select="tipIngExt" />
							</xsl:if>
							<xsl:if test="ingExtGravOtroPais != ''">
								<xsl:copy-of select="ingExtGravOtroPais" />
							</xsl:if>
							<tipoComprobante>
								<xsl:value-of select="tipoComprobante" />
							</tipoComprobante>
							<xsl:if test="exportacionDe = '01'">

								<xsl:copy-of select="distAduanero" />

								<anio>
									<xsl:value-of select="anio" />
								</anio>
								<regimen>
									<xsl:value-of select="regimen" />
								</regimen>
								<correlativo>
									<xsl:value-of select="correlativo" />
								</correlativo>
								<xsl:if test="verificador">
									<verificador>
										<xsl:value-of select="verificador" />
									</verificador>
								</xsl:if>

								<xsl:copy-of select="docTransp" />
							</xsl:if>

							<fechaEmbarque>
								<xsl:call-template name="date-converter">
									<xsl:with-param name="fecha" select="fechaEmbarque" />
								</xsl:call-template>
							</fechaEmbarque>
							<xsl:if test="fue !=''">
								<fue>
									<xsl:value-of select="fue" />
								</fue>
							</xsl:if>
							<valorFOB>
								<xsl:call-template name="default-number">
									<xsl:with-param name="valorNumerico" select="valorFOB" />
								</xsl:call-template>
							</valorFOB>
							<valorFOBComprobante>
								<xsl:call-template name="default-number">
									<xsl:with-param name="valorNumerico" select="valorFOBComprobante" />
								</xsl:call-template>
							</valorFOBComprobante>
							<establecimiento>
								<xsl:value-of select="establecimiento" />
							</establecimiento>
							<puntoEmision>
								<xsl:value-of select="puntoEmision" />
							</puntoEmision>
							<secuencial>
								<xsl:value-of select="secuencial" />
							</secuencial>
							<autorizacion>
								<xsl:value-of select="autorizacion" />
							</autorizacion>
							<fechaEmision>
								<xsl:call-template name="date-converter">
									<xsl:with-param name="fecha" select="fechaEmision" />
								</xsl:call-template>
							</fechaEmision>
						</detalleExportaciones>
					</xsl:for-each>
				</exportaciones>
			</xsl:if>

			<!-- ****RECAPS*** -->
			<xsl:if test="recap/cabecerasRecap">
				<recap>
					<xsl:for-each select="recap/cabecerasRecap/cabeceraRecap">
						<xsl:if test=" codRecap != '' ">
							<detalleRecap>
								<xsl:variable name="codigoRecap" select="codRecap" />
								<xsl:copy-of select="establecimientoRecap" />
								<xsl:copy-of select="identificacionRecap" />

								<xsl:if test="parteRelRec != ''">
									<xsl:copy-of select="parteRelRec" />
								</xsl:if>
								<xsl:if test="tipoEst != ''">
									<xsl:copy-of select="tipoEst" />
								</xsl:if>
								<xsl:if test="denoCliRecaps != ''">
									<xsl:copy-of select="denoCliRecaps" />
								</xsl:if>
								<xsl:copy-of select="tipoComprobante" />
								<xsl:copy-of select="numeroRecap" />

								<fechaPago>
									<xsl:call-template name="date-converter">
										<xsl:with-param name="fecha" select="fechaPago" />
									</xsl:call-template>
								</fechaPago>

								<tarjetaCredito>
									<xsl:value-of select="tarjetaCredito" />
								</tarjetaCredito>
								<fechaEmisionRecap>
									<xsl:call-template name="date-converter">
										<xsl:with-param name="fecha" select="fechaEmisionRecap" />
									</xsl:call-template>
								</fechaEmisionRecap>
								<consumoCero>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="consumoCero" />
									</xsl:call-template>
								</consumoCero>
								<consumoGravado>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="consumoGravado" />
									</xsl:call-template>
								</consumoGravado>
								<totalConsumo>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="totalConsumo" />
									</xsl:call-template>
								</totalConsumo>
								<montoIva>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="montoIva" />
									</xsl:call-template>
								</montoIva>
								<xsl:if test="../../compensaciones">
									<xsl:if
										test="../../compensaciones/compensacion[codModulo=$codigoRecap]">
										<compensaciones>
											<xsl:for-each
												select="../../compensaciones/compensacion[codModulo=$codigoRecap]">
												<compensacion>
													<xsl:copy-of select="tipoCompe" />
													<monto>
														<xsl:call-template name="default-number">
															<xsl:with-param name="valorNumerico"
																select="monto" />
														</xsl:call-template>
													</monto>
												</compensacion>
											</xsl:for-each>
										</compensaciones>
									</xsl:if>
								</xsl:if>
								<comision>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="comision" />
									</xsl:call-template>
								</comision>
								<numeroVouchers>
									<xsl:value-of select="numeroVouchers" />
								</numeroVouchers>
								<valRetBien10>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="valRetBien10" />
									</xsl:call-template>
								</valRetBien10>
								<valRetServ20>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="valRetServ20" />
									</xsl:call-template>
								</valRetServ20>
								<valorRetBienes>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="valorRetBienes" />
									</xsl:call-template>
								</valorRetBienes>
								<valRetServ50>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="valRetServ50" />
									</xsl:call-template>
								</valRetServ50>
								<valorRetServicios>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="valorRetServicios" />
									</xsl:call-template>
								</valorRetServicios>
								<valRetServ100>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="valRetServ100" />
									</xsl:call-template>
								</valRetServ100>

								<xsl:if test="pagoExterior/pagoLocExt != ''">
									<pagoExterior>
										<xsl:call-template name="pagoLocalYDelExterior">
											<xsl:with-param name="pagoExterior" select="pagoExterior" />
										</xsl:call-template>
									</pagoExterior>
								</xsl:if>

								<xsl:if test="../../retencionesRecap">
									<air>
										<xsl:for-each
											select="../../retencionesRecap/detalleAir[codRecap=$codigoRecap]">
											<detalleAir>
												<codRetAir>
													<xsl:value-of select="codRetAir" />
												</codRetAir>
												<baseImpAir>
													<xsl:call-template name="default-number">
														<xsl:with-param name="valorNumerico"
															select="baseImpAir" />
													</xsl:call-template>
												</baseImpAir>
												<porcentajeAir>
													<xsl:call-template name="default-number">
														<xsl:with-param name="valorNumerico"
															select="porcentajeAir" />
													</xsl:call-template>
												</porcentajeAir>
												<valRetAir>
													<xsl:call-template name="default-number">
														<xsl:with-param name="valorNumerico"
															select="valRetAir" />
													</xsl:call-template>
												</valRetAir>
											</detalleAir>
										</xsl:for-each>
									</air>
								</xsl:if>
								<establecimiento>
									<xsl:value-of select="establecimiento" />
								</establecimiento>
								<puntoEmision>
									<xsl:value-of select="puntoEmision" />
								</puntoEmision>
								<secuencial>
									<xsl:value-of select="secuencial" />
								</secuencial>
								<autorizacion>
									<xsl:value-of select="autorizacion" />
								</autorizacion>
								<fechaEmision>
									<xsl:call-template name="date-converter">
										<xsl:with-param name="fecha" select="fechaEmision" />
									</xsl:call-template>
								</fechaEmision>
							</detalleRecap>
						</xsl:if>
					</xsl:for-each>
				</recap>
			</xsl:if>
			<xsl:if test="fideicomisos/detallesFideicomisos">
				<fideicomisos>
					<xsl:for-each
						select="fideicomisos/detallesFideicomisos/detalleFideicomisos">
						<detalleFideicomisos>
							<xsl:variable name="codigoFideicomiso" select="rucFideicomiso" />

							<xsl:copy-of select="tipoBeneficiario" />
							<xsl:copy-of select="idBeneficiario" />
							<xsl:if test="parteRelExp !=''">
								<parteRelExp>
									<xsl:value-of select="parteRelExp" />
								</parteRelExp>
							</xsl:if>
							<xsl:if test="tipoBeneficiarioCli != ''">
								<xsl:copy-of select="tipoBeneficiarioCli" />
							</xsl:if>
							<xsl:if test="denoBenefi != ''">
								<xsl:copy-of select="denoBenefi" />
							</xsl:if>


							<xsl:copy-of select="rucFideicomiso" />

							<xsl:variable name="individual" select="individualF" />
							<xsl:variable name="porcentaje" select="porRetF" />
							<xsl:variable name="valor" select="valorRetF" />
							<xsl:variable name="pago" select="pagoExterior" />
							<xsl:variable name="fechaPago" select="fechaPagoDiv" />
							<xsl:variable name="impuestoRenta" select="imRentaSoc" />
							<xsl:variable name="anioUltimoDividendo" select="anioUtDiv" />
							<fValor>
								<xsl:for-each
									select="../../infoFideicomisos/defFideicomiso[rucFideicomiso=$codigoFideicomiso]">
									<detallefValor>
										<xsl:copy-of select="tipoFideicomiso" />

										<xsl:copy-of select="totalF" />
										<individualF>
											<xsl:call-template name="default-number">
												<xsl:with-param name="valorNumerico" select="$individual" />
											</xsl:call-template>
										</individualF>
										<porRetF>
											<xsl:call-template name="default-number">
												<xsl:with-param name="valorNumerico" select="$porcentaje" />
											</xsl:call-template>
										</porRetF>
										<valorRetF>
											<xsl:call-template name="default-number">
												<xsl:with-param name="valorNumerico" select="$valor" />
											</xsl:call-template>
										</valorRetF>
										<xsl:if test="$fechaPago != ''">
											<fechaPagoDiv>
												<xsl:call-template name="date-converter">
													<xsl:with-param name="fecha" select="$fechaPago" />
												</xsl:call-template>
											</fechaPagoDiv>
										</xsl:if>
										<xsl:if test="$impuestoRenta != ''">
											<imRentaSoc>
												<xsl:call-template name="default-number">
													<xsl:with-param name="valorNumerico" select="$impuestoRenta" />
												</xsl:call-template>
											</imRentaSoc>
										</xsl:if>
										<xsl:if test="$anioUltimoDividendo">
											<anioUtDiv>
												<xsl:value-of select="$anioUltimoDividendo" />
											</anioUtDiv>
										</xsl:if>
										<!--Nuevos -->
										<xsl:if test="$pago/pagoLocExt != ''">
											<pagoExterior>
												<xsl:copy-of select="$pago/pagoLocExt" />
												<xsl:if test="$pago/tipoRegi != ''">
													<xsl:copy-of select="$pago/tipoRegi" />
												</xsl:if>
												<xsl:if test="$pago/paisEfecPagoGen != ''">
													<xsl:copy-of select="$pago/paisEfecPagoGen" />
												</xsl:if>
												<xsl:if test="$pago/paisEfecPagoParFis != ''">
													<xsl:copy-of select="$pago/paisEfecPagoParFis" />
												</xsl:if>
												<xsl:if test="$pago/denopagoRegFis != ''">
													<xsl:copy-of select="$pago/denopagoRegFis" />
												</xsl:if>
												<xsl:if test="$pago/paisEfecPago != ''">
													<xsl:copy-of select="$pago/paisEfecPago" />
												</xsl:if>
												<xsl:copy-of select="$pago/aplicConvDobTrib" />
												<xsl:copy-of select="$pago/pagExtSujRetNorLeg" />
											</pagoExterior>
										</xsl:if>
									</detallefValor>
								</xsl:for-each>
							</fValor>
						</detalleFideicomisos>
					</xsl:for-each>
				</fideicomisos>
			</xsl:if>
			<!-- anulados se copia identico -->
			<xsl:copy-of select="anulados" />
			<!-- anulados se copia identico -->
			<!-- ****** rendimientos**** -->
			<xsl:if test="rendFinancieros">
				<rendFinancieros>
					<xsl:for-each select="rendFinancieros/retenidos/sujeto">
						<detalleRendFinancieros>
							<xsl:variable name="codigoRetenido" select="idRetenido" />
							<retenido>
								<xsl:value-of select="retenido" />
							</retenido>
							<idRetenido>
								<xsl:value-of select="idRetenido" />
							</idRetenido>
							<xsl:if test="parteRelFid">
								<xsl:copy-of select="parteRelFid" />
							</xsl:if>
							<xsl:if test="tipoRete != ''">
								<xsl:copy-of select="tipoRete" />
							</xsl:if>
							<xsl:if test="denoBenefi != ''">
								<xsl:copy-of select="denoBenefi" />
							</xsl:if>

							<!--<xsl:if test="ahorroPN/totalDep!=''"> -->
							<ahorroPN>
								<totalDep>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="ahorroPN/totalDep" />
									</xsl:call-template>
								</totalDep>
								<rendGen>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="ahorroPN/rendGen" />
									</xsl:call-template>
								</rendGen>
							</ahorroPN>
							<!--</xsl:if> -->
							<!--<xsl:if test="ctaExenta/totalDep!=''"> -->
							<ctaExenta>
								<totalDep>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="ctaExenta/totalDep" />
									</xsl:call-template>
								</totalDep>
								<rendGen>
									<xsl:call-template name="default-number">
										<xsl:with-param name="valorNumerico" select="ctaExenta/rendGen" />
									</xsl:call-template>
								</rendGen>
							</ctaExenta>
							<!--</xsl:if> -->
							<xsl:if
								test="../../comprobantesRetencion/detRet[idRetenido=$codigoRetenido]">
								<retenciones>
									<xsl:for-each
										select="../../comprobantesRetencion/detRet[idRetenido=$codigoRetenido]">
										<xsl:variable name="numeroComprobante" select="idRetencion" />
										<detRet>
											<xsl:if test="pagoExterior/pagoLocExt != ''">
												<pagoExterior>
													<xsl:call-template name="pagoLocalYDelExterior">
														<xsl:with-param name="pagoExterior" select="pagoExterior" />
													</xsl:call-template>
												</pagoExterior>
											</xsl:if>
											<estabRetencion>
												<xsl:value-of select="estabRetencion" />
											</estabRetencion>
											<ptoEmiRetencion>
												<xsl:value-of select="ptoEmiRetencion" />
											</ptoEmiRetencion>
											<secRetencion>
												<xsl:value-of select="secRetencion" />
											</secRetencion>
											<autRetencion>
												<xsl:value-of select="autRetencion" />
											</autRetencion>
											<fechaEmiRet>
												<xsl:call-template name="date-converter">
													<xsl:with-param name="fecha" select="fechaEmiRet" />
												</xsl:call-template>
											</fechaEmiRet>
											<xsl:if test="../../conceptosRetencion">
												<xsl:if
													test="../../conceptosRetencion/detalleAirRen[idRetencion=$numeroComprobante]">
													<airRend>
														<xsl:for-each
															select="../../conceptosRetencion/detalleAirRen[idRetencion=$numeroComprobante]">
															<detalleAirRen>
																<codRetAir>
																	<xsl:value-of select="codRetAir" />
																</codRetAir>
																<deposito>
																	<xsl:call-template name="default-number">
																		<xsl:with-param name="valorNumerico"
																			select="deposito" />
																	</xsl:call-template>
																</deposito>
																<baseImpAir>
																	<xsl:call-template name="default-number">
																		<xsl:with-param name="valorNumerico"
																			select="baseImpAir" />
																	</xsl:call-template>
																</baseImpAir>
																<porcentajeAir>
																	<xsl:call-template name="default-number">
																		<xsl:with-param name="valorNumerico"
																			select="porcentajeAir" />
																	</xsl:call-template>
																</porcentajeAir>
																<valRetAir>
																	<xsl:call-template name="default-number">
																		<xsl:with-param name="valorNumerico"
																			select="valRetAir" />
																	</xsl:call-template>
																</valRetAir>
															</detalleAirRen>
														</xsl:for-each>
													</airRend>
												</xsl:if>
											</xsl:if>
										</detRet>
									</xsl:for-each>
								</retenciones>
							</xsl:if>
						</detalleRendFinancieros>
					</xsl:for-each>
				</rendFinancieros>
			</xsl:if>
		</iva>
	</xsl:template>

	<!-- formateo de fechas -->
	<xsl:template name="date-converter">
		<xsl:param name="fecha" />
		<xsl:choose>
			<xsl:when test="$fecha != '' and matches($fecha,'\d{4}-\d{2}-\d{2}')">
				<xsl:value-of select="format-date($fecha, '[D01]/[M01]/[Y0001]')" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$fecha" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- template para transformar los valores numericos! -->
	<xsl:template name="default-number">
		<xsl:param name="valorNumerico" />
		<xsl:choose>
			<xsl:when test="$valorNumerico != ''">
				<xsl:value-of
					select="format-number(translate($valorNumerico, ',','.'), '#0.00')" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>0.00</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- template para el pago local y del exterior -->
	<xsl:template name="pagoLocalYDelExterior">
		<xsl:param name="pagoExterior" />
		<xsl:copy-of select="pagoExterior/pagoLocExt" />
		<xsl:choose>
			<xsl:when test="$pagoExterior/pagoLocExt = '01'">
				<xsl:choose>
					<xsl:when test="$pagoExterior/paisEfecPago = ''">
						<paisEfecPago>NA</paisEfecPago>
					</xsl:when>
					<xsl:otherwise>
						<xsl:copy-of select="pagoExterior/paisEfecPago" />
					</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="$pagoExterior/aplicConvDobTrib = ''">
						<aplicConvDobTrib>NA</aplicConvDobTrib>
					</xsl:when>
					<xsl:otherwise>
						<xsl:copy-of select="pagoExterior/aplicConvDobTrib" />
					</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="$pagoExterior/pagExtSujRetNorLeg = ''">
						<pagExtSujRetNorLeg>NA</pagExtSujRetNorLeg>
					</xsl:when>
					<xsl:otherwise>
						<xsl:copy-of select="pagoExterior/pagExtSujRetNorLeg" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="pagoExterior/tipoRegi != ''">
					<xsl:copy-of select="pagoExterior/tipoRegi" />
				</xsl:if>
				<xsl:if test="pagoExterior/paisEfecPagoGen != ''">
					<xsl:copy-of select="pagoExterior/paisEfecPagoGen" />
				</xsl:if>
				<xsl:if test="pagoExterior/paisEfecPagoParFis != ''">
					<xsl:copy-of select="pagoExterior/paisEfecPagoParFis" />
				</xsl:if>
				<xsl:if test="pagoExterior/denopagoRegFis != ''">
					<xsl:copy-of select="pagoExterior/denopagoRegFis" />
				</xsl:if>
				<xsl:if test="pagoExterior/paisEfecPago != ''">
					<xsl:copy-of select="pagoExterior/paisEfecPago" />
				</xsl:if>
				<xsl:copy-of select="pagoExterior/aplicConvDobTrib" />
				<xsl:copy-of select="pagoExterior/pagExtSujRetNorLeg" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>